using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.ServiceContracts;
using BMS.DataContracts;
using BMS.Utils;
using System.ServiceModel;

namespace BMS.ServicesWrapper.Proxy
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface IBedManagerOperationsChannel : IBedManagerOperations, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class BedManagerOperationsClient : System.ServiceModel.ClientBase<IBedManagerOperations>, IBedManagerOperations, System.IDisposable
    {
        #region ProxyTool Generated Code

        private BedManagerOperationsClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;



        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new BedManagerOperationsClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new BedManagerOperationsClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new BedManagerOperationsClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new BedManagerOperationsClient(_endpointConfigurationName);
                else
                    _instance = new BedManagerOperationsClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        
        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<IBedManagerOperations>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<IBedManagerOperations>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<IBedManagerOperations>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<IBedManagerOperations>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public BedManagerOperationsClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerOperationsClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerOperationsClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerOperationsClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerOperationsClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateAdmissionOrder(AdmissionOrder admissionOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateAdmissionOrder(admissionOrder);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateAdmissionOrder(admissionOrder);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public AdmissionOrder GetAdmissionOrder(II admissionOrderId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetAdmissionOrder(admissionOrderId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetAdmissionOrder(admissionOrderId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateAdmissionOrder(AdmissionOrder admissionOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateAdmissionOrder(admissionOrder);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateAdmissionOrder(admissionOrder);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateAdmissionEvent(AdmissionEvent admissionEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateAdmissionEvent(admissionEvent);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateAdmissionEvent(admissionEvent);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public AdmissionEvent GetAdmissionEvent(II admissionEventId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetAdmissionEvent(admissionEventId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetAdmissionEvent(admissionEventId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public AdmissionEvent GetAdmissionEventForPatient(II patientId, II vistaId, string eventIen, DateTime? eventDateTime)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetAdmissionEventForPatient(patientId, vistaId, eventIen, eventDateTime);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetAdmissionEventForPatient(patientId, vistaId, eventIen, eventDateTime);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateAdmissionEvent(AdmissionEvent admissionEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateAdmissionEvent(admissionEvent);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateAdmissionEvent(admissionEvent);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateScheduledAdmission(ScheduledAdmission scheduledAdmission)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateScheduledAdmission(scheduledAdmission);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateScheduledAdmission(scheduledAdmission);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ScheduledAdmission GetScheduledAdmission(II scheduledAdmissionId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetScheduledAdmission(scheduledAdmissionId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetScheduledAdmission(scheduledAdmissionId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateScheduledAdmission(ScheduledAdmission scheduledAdmission)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateScheduledAdmission(scheduledAdmission);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateScheduledAdmission(scheduledAdmission);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateTransfer(Transfer transfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateTransfer(transfer);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateTransfer(transfer);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public Transfer GetTransfer(II transferId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetTransfer(transferId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetTransfer(transferId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateTransfer(Transfer transfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateTransfer(transfer);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateTransfer(transfer);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateDischargeAppointment(DischargeAppointment dischargeAppointment)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateDischargeAppointment(dischargeAppointment);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateDischargeAppointment(dischargeAppointment);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DischargeAppointment GetDischargeAppointment(II dischargeAppointmentId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetDischargeAppointment(dischargeAppointmentId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetDischargeAppointment(dischargeAppointmentId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateDischargeAppointment(DischargeAppointment dischargeAppointment)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateDischargeAppointment(dischargeAppointment);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateDischargeAppointment(dischargeAppointment);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateDischargeOrder(DischargeOrder dischargeOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateDischargeOrder(dischargeOrder);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateDischargeOrder(dischargeOrder);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DischargeOrder GetDischargeOrder(II dischargeOrderId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetDischargeOrder(dischargeOrderId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetDischargeOrder(dischargeOrderId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateDischargeOrder(DischargeOrder dischargeOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateDischargeOrder(dischargeOrder);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateDischargeOrder(dischargeOrder);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateDischargeEvent(DischargeEvent dischargeEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateDischargeEvent(dischargeEvent);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateDischargeEvent(dischargeEvent);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DischargeEvent GetDischargeEvent(II dischargeEventId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetDischargeEvent(dischargeEventId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetDischargeEvent(dischargeEventId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateDischargeEvent(DischargeEvent dischargeEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateDischargeEvent(dischargeEvent);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateDischargeEvent(dischargeEvent);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateBedCleaningOperation(BedCleaningOperation bedCleaningOperation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateBedCleaningOperation(bedCleaningOperation);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateBedCleaningOperation(bedCleaningOperation);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedCleaningOperation GetBedCleaningOperation(II bedCleaningOperationId, II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetBedCleaningOperation(bedCleaningOperationId, bedId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetBedCleaningOperation(bedCleaningOperationId, bedId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateBedCleaningOperation(BedCleaningOperation bedCleaningOperation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateBedCleaningOperation(bedCleaningOperation);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateBedCleaningOperation(bedCleaningOperation);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateBedUnavailable(BedUnavailable bedUnavailable)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateBedUnavailable(bedUnavailable);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateBedUnavailable(bedUnavailable);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedUnavailable GetBedUnavailable(II bedUnavailableId, II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetBedUnavailable(bedUnavailableId, bedId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetBedUnavailable(bedUnavailableId, bedId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateBedUnavailable(BedUnavailable bedUnavailable)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateBedUnavailable(bedUnavailable);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateBedUnavailable(bedUnavailable);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateDiversion(Diversion diversion)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateDiversion(diversion);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateDiversion(diversion);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public Diversion GetDiversion(II diversionId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetDiversion(diversionId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetDiversion(diversionId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateDiversion(Diversion diversion)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateDiversion(diversion);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateDiversion(diversion);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateMovementOrder(MovementOrder movementOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateMovementOrder(movementOrder);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateMovementOrder(movementOrder);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public MovementOrder GetMovementOrder(II movementOrderId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetMovementOrder(movementOrderId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetMovementOrder(movementOrderId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateMovementOrder(MovementOrder movementOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateMovementOrder(movementOrder);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateMovementOrder(movementOrder);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateMovementEvent(MovementEvent movementEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateMovementEvent(movementEvent);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateMovementEvent(movementEvent);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public MovementEvent GetMovementEvent(II movementEventId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetMovementEvent(movementEventId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetMovementEvent(movementEventId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateMovementEvent(MovementEvent movementEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateMovementEvent(movementEvent);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateMovementEvent(movementEvent);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<Diversion> GetAllDiversion(II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetAllDiversion(facilityId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetAllDiversion(facilityId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateWaitingListItem(WaitingListItem waitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateWaitingListItem(waitingListItem);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateWaitingListItem(waitingListItem);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public WaitingListItem GetWaitingListItem(II waitingListItemId, string patientSSN)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetWaitingListItem(waitingListItemId, patientSSN);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetWaitingListItem(waitingListItemId, patientSSN);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateWaitingListItem(WaitingListItem waitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateWaitingListItem(waitingListItem);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateWaitingListItem(waitingListItem);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertBedUnavailableHistory(BedUnavailableHistory bedUnavailableHistory)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertBedUnavailableHistory(bedUnavailableHistory);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertBedUnavailableHistory(bedUnavailableHistory);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public int CreateIconDetail(IconDetail iconDetail)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateIconDetail(iconDetail);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateIconDetail(iconDetail);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IconDetail GetIconDetail(int iconDetailId, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetIconDetail(iconDetailId, facilityId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetIconDetail(iconDetailId, facilityId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateIconDetail(IconDetail iconDetail)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateIconDetail(iconDetail);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateIconDetail(iconDetail);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteIconDetail(int iconDetailId, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteIconDetail(iconDetailId, facilityId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteIconDetail(iconDetailId, facilityId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void SwitchIconOrder(DataContracts.IconInfo icon1, DataContracts.IconInfo icon2)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.SwitchIconOrder(icon1, icon2);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.SwitchIconOrder(icon1, icon2);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateIconOrder(List<IconOrder> iconOrderList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateIconOrder(iconOrderList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateIconOrder(iconOrderList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateIconOrderBulk(List<IconOrder> iconOrderList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateIconOrderBulk(iconOrderList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateIconOrderBulk(iconOrderList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertIconAssociation(IconAssociation iconAssociation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertIconAssociation(iconAssociation);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertIconAssociation(iconAssociation);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public void DeleteIconAssociation(Guid patientUID, int? iconFlagId = null)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteIconAssociation(patientUID, iconFlagId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteIconAssociation(patientUID, iconFlagId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public PatientLocation GetPatientLocation(II patientId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetPatientLocation(patientId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetPatientLocation(patientId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateBedSwitch(BedSwitch bedSwitch)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateBedSwitch(bedSwitch);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateBedSwitch(bedSwitch);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void CreateBedStaff(BedStaff bedStaff)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.CreateBedStaff(bedStaff);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.CreateBedStaff(bedStaff);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteBedStaff(II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteBedStaff(bedId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteBedStaff(bedId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedStaff GetBedStaff(II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetBedStaff(bedId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetBedStaff(bedId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<LoggedUser> GetLoggedUsers(string domainId, string facilityIdList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetLoggedUsers(domainId, facilityIdList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetLoggedUsers(domainId, facilityIdList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertLoggedUsers(LoggedUser user)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertLoggedUsers(user);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertLoggedUsers(user);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public void DeleteEmsStaff(II emsStaffId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteEmsStaff(emsStaffId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteEmsStaff(emsStaffId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void CreateEmsStaff(EmsStaff emsStaff)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.CreateEmsStaff(emsStaff);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.CreateEmsStaff(emsStaff);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateEmsStaff(EmsStaff emsStaff)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateEmsStaff(emsStaff);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateEmsStaff(emsStaff);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public EmsStaff GetEmsStaff(II emsStaffId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetEmsStaff(emsStaffId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetEmsStaff(emsStaffId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public int AddLogEntry(DataContracts.JobLogInfo logEntry)
        {
            try
            {
                return _instance.Channel.AddLogEntry(logEntry);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.AddLogEntry(logEntry);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public void UpdateLogEntry(DataContracts.JobLogInfo logEntry)
        {
            try
            {
                _instance.Channel.UpdateLogEntry(logEntry);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.UpdateLogEntry(logEntry);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public IList<VistaOperation> GetData(string vistaId)
        {
            try
            {
                return _instance.Channel.GetData(vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.GetData(vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public void UpdateData(VistaOperation vistaOperation)
        {
            try
            {
                _instance.Channel.UpdateData(vistaOperation);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.UpdateData(vistaOperation);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public void DeleteData(string vistaId)
        {
            try
            {
                _instance.Channel.DeleteData(vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.DeleteData(vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }


        public void SaveLevelOfCare(LevelOfCareData data)
        {
            try
            {
                _instance.Channel.SaveLevelOfCare(data);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.SaveLevelOfCare(data);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public void SaveVistaIntegrationLog(VistaIntegrationLog vistaIntegrationLog, string vista)
        {
            try
            {
                _instance.Channel.SaveVistaIntegrationLog(vistaIntegrationLog, vista);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.SaveVistaIntegrationLog(vistaIntegrationLog, vista);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }


        public void CreateSpecialtyTransfer(SpecialtyTransfer specialtyTransfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.CreateSpecialtyTransfer(specialtyTransfer);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.CreateSpecialtyTransfer(specialtyTransfer);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            } 
        }

        public SpecialtyTransfer GetSpecialtyTransfer(II specialtyTransferId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetSpecialtyTransfer(specialtyTransferId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetSpecialtyTransfer(specialtyTransferId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateSpecialtyTransfer(SpecialtyTransfer specialtyTransfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateSpecialtyTransfer(specialtyTransfer);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateSpecialtyTransfer(specialtyTransfer);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public void CreateHospitalLocationAppointment(HospitalLocationAppointment hospitalLocationAppointment)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.CreateHospitalLocationAppointment(hospitalLocationAppointment);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.CreateHospitalLocationAppointment(hospitalLocationAppointment);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        public List<HospitalLocationAppointment> GetHospitalLocationsAppointment(Guid? facilityUid, Guid? vistaSiteUid)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetHospitalLocationsAppointment(facilityUid, vistaSiteUid);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetHospitalLocationsAppointment(facilityUid, vistaSiteUid);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public HospitalLocationAppointment GetHospitalLocationAppointment(II hospitalLocationAppointmentId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetHospitalLocationAppointment(hospitalLocationAppointmentId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetHospitalLocationAppointment(hospitalLocationAppointmentId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteHospitalLocationAppointment(II hospitalLocationAppointmentId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteHospitalLocationAppointment(hospitalLocationAppointmentId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteHospitalLocationAppointment(hospitalLocationAppointmentId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ScheduledAdmission GetScheduledAdmissionByIen(II vistaId, string ien)
        {
            try
            {
                return _instance.Channel.GetScheduledAdmissionByIen(vistaId, ien);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.GetScheduledAdmissionByIen(vistaId, ien);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public DischargeAppointment GetDischargeIntent(DateTime appointmentDateTime, II vistaId)
        {
            try
            {
                return _instance.Channel.GetDischargeIntent(appointmentDateTime, vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.GetDischargeIntent(appointmentDateTime, vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public void ManageDeletedMovements(string iens, II vistaId, string vistaCode)
        {
            try
            {
                _instance.Channel.ManageDeletedMovements(iens, vistaId, vistaCode);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.ManageDeletedMovements(iens, vistaId, vistaCode);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public void UpdateMovementsWithoutBed(string iens, II vistaId)
        {
            try
            {
                _instance.Channel.UpdateMovementsWithoutBed(iens, vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.UpdateMovementsWithoutBed(iens, vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

        public void ClearLoggedUsers(string domainId)
        {
            try
            {
                _instance.Channel.ClearLoggedUsers(domainId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.ClearLoggedUsers(domainId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
            }
        }

		public void UpdateAuditJobsFailedWithStatusRunningToFailed()
		{
			DateTime entryInLogMethodTime = DateTime.UtcNow;
			if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
			{
				InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
			}
			try
			{
				try
				{
					_instance.Channel.UpdateAuditJobsFailedWithStatusRunningToFailed();
				}
				catch (System.Exception e)
				{
					if (!ProxyManager.CheckThrownException(e))
						throw;
					else
					{
						InitProxyInstance();
						_instance.Channel.UpdateAuditJobsFailedWithStatusRunningToFailed();
					}
				}
				finally
				{
					ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
				}
			}
			finally
			{
				if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
				{
					InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
				}
			}
		}

        public string GetVistaPatientIen(string vistaCode)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetVistaPatientIen(vistaCode);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetVistaPatientIen(vistaCode);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
	}
}
